package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditDoorDestinationPaletteObjectWizard extends JPanel {
	
	private JTextField destLabel;
	private SharedColor labelColor;
	private MicroColorCanvas colorCanvas;
	private JDialog frame;
	private boolean wasCancelled = true;
	
	public EditDoorDestinationPaletteObjectWizard(JDialog theFrame) {
		
		frame = theFrame;
		
		this.setLayout(new BorderLayout());
		
		JPanel mainPanel = new JPanel(new GridLayout(1, 2));
		JPanel colorPanel = new JPanel(new FlowLayout());
		colorPanel.add(new JLabel("Label color (optional): "));
		labelColor = new SharedColor();
		colorCanvas = new MicroColorCanvas(labelColor);
		colorPanel.add(colorCanvas);
		JButton changeColorButton = new JButton("Change...");
		changeColorButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(labelColor, colorCanvas);
			}
		});
		colorPanel.add(changeColorButton);
		mainPanel.add(colorPanel);
		
		JPanel textPanel = new JPanel(new FlowLayout());
		textPanel.add(new JLabel("Label (optional): "));
		destLabel = new JTextField(3);
		textPanel.add(destLabel);
		mainPanel.add(textPanel);
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		JPanel lowerPanel = new JPanel(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				cancel();
			}
		});
		lowerPanel.add(cancelButton);
		
		
		lowerPanel.add(new JPanel());
		lowerPanel.add(new JPanel());
		
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				ok();
			}
		});
		lowerPanel.add(okButton);
		
		this.add(lowerPanel, BorderLayout.SOUTH);
	}
	
	
	public void cancel() {
		wasCancelled = true;
		frame.dispose();
	}
	
	public void ok() {
		
		wasCancelled = false;
		frame.dispose();
		
	}
	
	
	public String getCaption() {
		return destLabel.getText();
	}
	
	public Color getCaptionColor() {
		return labelColor.getColor();
	}
	
	public boolean wasCancelled() {
		return wasCancelled;
	}
	
}
